<?php
/* --------------------------------------------------------------
 LanguageSpecificConfiguration.php 2020-03-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Models\Write;

/**
 * Class LanguageSpecificConfiguration
 * @package Gambio\Core\Configuration\Models\Write
 */
class LanguageSpecificConfiguration implements Interfaces\Configuration, Interfaces\LanguageSpecificConfiguration
{
    /**
     * @var string
     */
    private $key;
    
    /**
     * @var array
     */
    private $value;
    
    
    /**
     * Configuration constructor.
     *
     * @param string $key
     * @param array  $value
     */
    private function __construct(string $key, array $value)
    {
        $this->key   = $key;
        $this->value = $value;
    }
    
    
    /**
     * Factory method to create Configuration.
     *
     * @param string $key
     * @param array  $value
     *
     * @return static
     */
    public static function create(string $key, array $value): self
    {
        return new static($key, $value);
    }
    
    
    /**
     * @inheritDoc
     */
    public function key(): string
    {
        return $this->key;
    }
    
    
    /**
     * @inheritDoc
     */
    public function value(): array
    {
        return $this->value;
    }
}